plotlinewidth=4;
%,'Display','iter'
start=[3; guess_maximum;0 ];
up = [10;guess_maximum*1.05;0.01];
low = [2;guess_maximum*0.95;-0.01];%d?mpfung, resonanzfrequenz,y-offset, peak-h?he
[val_low, index_low]=min(abs(result_frequency(:)-guess_maximum*0.7));
[val_up, index_up]=min(abs(result_frequency(:)-guess_maximum*1.3));
optionsforfit = fitoptions('Method', 'NonlinearLeastSquares','MaxIter',200,'TolFun',10^-10,'TolX',10^-10,'Upper',up,'Lower',low,'StartPoint',start);
% 4*(d*a*b)^2/((x^2-b^2)^2+4*(a*b)^2) + c
%atan(2*x*a/(b^2-x^2))+c

typeoffit = fittype('1/pi*atan(2*x*a/(b^2-x*x))+c+heaviside(x-b)', 'options', optionsforfit);


fitobject=fit(result_frequency(index_low:index_up)',phase_angle_result(index_low:index_up)',typeoffit)
%fitobject=fit(transpose(data(dampnr,index_low:index_up,1)),transpose(data(dampnr,index_low:index_up,2)),typeoffit);
x=linspace(100,160,1000);
coeff=coeffvalues(fitobject);
a=coeff(1);
b=coeff(2);
c=coeff(3);


FWHM=2*a;
f_res=b;
Q=f_res/(FWHM);

hold on
semilogx(x,1/pi*atan(2*x.*a./(b^2-x.*x))+c+heaviside(x-b),'LineWidth',1.8)
semilogx(result_frequency(index_low:index_up)',phase_angle_result(index_low:index_up)','+','Linewidth',plotlinewidth,'color','r')


dim = [.2 .74 .8 .15];
%annotation('textbox',dim,'String',['f_0=', num2str(b,7),' kHz', newline , 'FWHM=', num2str(FWHM,3), ' kHz', newline,'Q=',num2str(Q,4)],'FitBoxToText','on');

%xlabel('frequency {f} in kHz')
xlabel('frequency $f$ (kHz) ','interpreter','latex') 


%ylabel('phase angle \phi in rad')
ylabel('phase angle $\phi$ (rad) ','interpreter','latex') 
phase_angle_fit=1/pi*atan(2*x.*a./(b^2-x.*x))+c+heaviside(x-b);
fit_result_phase=[a b c];
hold off
save('fit_result_phase.dat'  ,  'fit_result_phase', '-ascii' ,'-tabs');
save('phase_angle_fit.dat'  ,  'phase_angle_fit', '-ascii' ,'-tabs');
save('x_phase.dat'  ,  'x', '-ascii' ,'-tabs');
